####################################
# Simple example of Bayesian inference based on discrete theta
# Author: Michail Tsikerdekis
# Description: It demonstrates the process by which one can update prior beliefs to posterior using Bayes' Rule
####################################

# Digital device example
Theta = c(0,0.2,0.4,0.6,0.8,1)
#Theta = c(1,1.25,1.5,1.75,2)

pTheta = rep(0.20,length(Theta)) # Assigning equal probabilities to all possibilities (outcomes)
pTheta = c(0.1,0.15,0.15,0.20,0.20,0.4)

Data = c(1)
Data = rep(1,10)

s = sum( Data == 1 )
f = sum( Data == 0 )

# Likelihood for each Theta value
pDataGivenTheta = Theta^s * (1-Theta)^f
pDataGivenTheta
pDataGivenTheta / sum(pDataGivenTheta)

# Evidence
pData = sum( pDataGivenTheta * pTheta )

# Bayes' rule
pThetaGivenData = (pDataGivenTheta * pTheta) / pData
pThetaGivenData

library(ggplot2)
source("multiplot.R")
df = data.frame(pThetaGivenData = pThetaGivenData, pDataGivenTheta = pDataGivenTheta, Theta = Theta, pTheta = pTheta)

p1 = ggplot(data=df, aes(x=Theta, y=pTheta, fill=Theta)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Prior") +xlab(expression(theta)) +
  ylab(expression(p(theta))) + theme_minimal()
  #scale_x_discrete( breaks = df$Theta ,labels = c("Very Probably Not","Probably Not","Probably","Very Probably","Definitely"))

p2 = ggplot(data=df, aes(x=Theta, y=pDataGivenTheta, fill=Theta)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Likelihood") +xlab(expression(theta)) +
  ylab(bquote(paste("p(D|",theta,")"))) + theme_minimal()

p3 = ggplot(data=df, aes(x=Theta, y=pThetaGivenData, fill=Theta)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Posterior") +xlab(expression(theta)) +
  ylab(bquote(paste("p(",theta,"|D)"))) + theme_minimal()

multiplot(p1, p2, p3, cols=1)


#--------------------------- Other code
library(ggplot2)
source("multiplot.R")

Theta1 = c(0,0.2,0.4,0.6,0.8,1)
pTheta1 = c(0.1,0.15,0.15,0.20,0.20,0.4)
Theta2 = c(0,0.2,0.4,0.6,0.8,1)
pTheta2 = rep(0.20,length(Theta2))

df = data.frame(Theta1 = Theta1, Theta2 = Theta2, pTheta1 = pTheta1, pTheta2 = pTheta2)

p1 = ggplot(data=df, aes(x=Theta1, y=pTheta1, fill=Theta1)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Subjective Prior") +xlab(expression(theta)) +
  ylab(expression(p(theta))) + theme_minimal()

p2 = ggplot(data=df, aes(x=Theta2, y=pTheta2, fill=Theta2)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Objective Prior") +xlab(expression(theta)) +
  ylab(expression(p(theta))) + theme_minimal()

multiplot(p1, p2, cols=2)


ggplot(data=df, aes(x=Theta, y=pDataGivenTheta, fill=Theta)) +
  geom_bar(colour="black", stat="identity") +
  guides(fill=FALSE) +  ggtitle("Likelihood") +xlab(expression(theta)) +
  ylab(bquote(paste("p(D|",theta,")"))) + theme_minimal()